#pragma once
#include "afxwin.h"
#include "afxcmn.h"

// CDriverSettings1 dialog
class CDriverSettings1 : public CPropertyPage
{
#define MAX_BLACK_AREAS  10

	DECLARE_DYNAMIC(CDriverSettings1)

public:
	CDriverSettings1();
	virtual ~CDriverSettings1();
	virtual BOOL OnInitDialog();
	virtual BOOL OnSetActive();

// Dialog Data
	enum { IDD = IDD_DRIVERPAGE1 };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

	afx_msg void OnBnClickedBtnDriverboxclear();
	afx_msg void OnBnClickedBtnGUIcontrol();
	afx_msg void OnBnClickedBtnSharpness();
	afx_msg void OnBnClickedBtnColourcorrection();
	afx_msg void OnBnClickedBtnPrintspeed();
	afx_msg void OnBnClickedBtnPowerlevel();
	afx_msg void OnBnClickedBtnResinarea();
	afx_msg void OnBnClickedBtnAreahole();
	afx_msg void OnBnClickedGetActionRadio();
	afx_msg void OnBnClickedSetActionRadio();
	afx_msg void OnBnClickedBtnRewritable();
	afx_msg void OnCbnSelchangeResinArea();
	afx_msg void OnCbnSelchangeAreaHole();
	afx_msg void OnEnChangeResinareaNo();
	afx_msg void OnEnChangeAreaholeNo();
	afx_msg void OnBnClickedPrintablearea();
	afx_msg void OnBnClickedBtnResolution();

private:
	CMainSheet *Parent;
	BOOL Initialised;

	CEdit Driver1Msg;
	CButton Action;
	int DvrAction;
	CButton GUIUser;
	CButton GUIPrinter;
	CComboBox ColourCorrection;
	CButton PrintSpeedBtn;
	CComboBox PrintSpeed;
	CEdit Sharpness;
	CSpinButtonCtrl Sharpness_Spin;
	CEdit YMCPower;
	CSpinButtonCtrl YMCPower_Spin;
	CEdit KPower;
	CSpinButtonCtrl KPower_Spin;
	CEdit OPower;
	CSpinButtonCtrl OPower_Spin;
	CComboBox ResinArea_Side;
	CEdit ResinArea_No;
	CSpinButtonCtrl ResinArea_No_Spin;
	CEdit ResinArea_Left;
	CSpinButtonCtrl ResinArea_Left_Spin;
	CEdit ResinArea_Width;
	CSpinButtonCtrl ResinArea_Width_Spin;
	CEdit ResinArea_Bottom;
	CSpinButtonCtrl ResinArea_Bottom_Spin;
	CEdit ResinArea_Height;
	CSpinButtonCtrl ResinArea_Height_Spin;
	CEdit AreaHole_No;
	CSpinButtonCtrl AreaHole_No_Spin;
	CComboBox AreaHole_Side;
	CComboBox AreaHole_Type;
	CEdit AreaHole_Left;
	CSpinButtonCtrl AreaHole_Left_Spin;
	CEdit AreaHole_Width;
	CSpinButtonCtrl AreaHole_Width_Spin;
	CEdit AreaHole_Bottom;
	CSpinButtonCtrl AreaHole_Bottom_Spin;
	CEdit AreaHole_Height;
	CSpinButtonCtrl AreaHole_Height_Spin;
	CEdit EraseArea_Left;
	CSpinButtonCtrl EraseArea_Left_Spin;
	CEdit EraseArea_Width;
	CSpinButtonCtrl EraseArea_Width_Spin;
	CEdit EraseArea_Bottom;
	CSpinButtonCtrl EraseArea_Bottom_Spin;
	CEdit EraseArea_Height;
	CSpinButtonCtrl EraseArea_Height_Spin;
	CEdit ErasePower_Start;
	CSpinButtonCtrl ErasePower_Start_Spin;
	CEdit ErasePower_End;
	CSpinButtonCtrl ErasePower_End_Spin;
	CEdit WritePower;
	CSpinButtonCtrl WritePower_Spin;
	CButton EraseBeforePrint;
	CEdit PrintableArea_Left;
	CSpinButtonCtrl PrintableArea_Left_Spin;
	CEdit PrintableArea_Width;
	CSpinButtonCtrl PrintableArea_Width_Spin;
	CEdit PrintableArea_Bottom;
	CSpinButtonCtrl PrintableArea_Bottom_Spin;
	CEdit PrintableArea_Height;
	CSpinButtonCtrl PrintableArea_Height_Spin;
	CStatic ErasePowerEndLabel;
	CStatic WritePowerLabel;
	CButton PrintableAreaBtn;

	int GetResolutionRadio();
	CButton ResolutionBtn;
	int ResolutionRadio;

	void GUIControlToMsgBox(PID_GUICONTROL pControl,ID_READWRITE Action);
	void SetGUIControl(PID_GUICONTROL pControl);
	ID_RETURN GetGUIControl(PID_GUICONTROL pControl);

	void SharpnessToMsgBox(signed char Sharpness, ID_READWRITE Action);
	void SetSharpness(int Sharpness);
	ID_RETURN GetSharpness(signed char *pSharpness);

	void CorrectionToMsgBox(COLCORRECT Correction,	ID_READWRITE Action);
	void SetColourCorrection(COLCORRECT Correction);
	ID_RETURN GetColourCorrection(PCOLCORRECT pCorrection);

	CString PrintSpeedString(ID_PRINTSPEED PrintSpeed);
	void PrintSpeedToMsgBox(ID_PRINTSPEED Speed, ID_READWRITE Action);
	void SetPrintSpeed(ID_PRINTSPEED Speed);
	ID_RETURN GetPrintSpeed(PID_PRINTSPEED PID_PRINTSPEED);

	void PowerLevelsToMsgBox(POWERLEVEL PowerLevel, ID_READWRITE Action);
	void SetPowerLevels(POWERLEVEL PowerLevel);
	ID_RETURN GetPowerLevels(PPOWERLEVEL pPowerLevel);

	void ResinAreaToMsgBox(ID_SIDE Side, int AreaNo, PAREA pArea, ID_READWRITE Action);
	void SetResinArea(PAREA pArea);
	ID_RETURN GetResinArea(ID_SIDE Side, int AreaNo, PAREA pArea);

	void PrintableAreaToMsgBox(PAREA pArea, ID_READWRITE Action);
	void SetPrintableArea(PAREA pArea);
	ID_RETURN GetPrintableArea(PAREA pArea);

	void AreaHoleToMsgBox(ID_SIDE Side, ID_AREAHOLE Type, int AreaNo, PAREA pArea, ID_READWRITE Action);
	void SetAreaHole(PAREA pArea);
	ID_RETURN GetAreaHole(ID_SIDE Side, ID_AREAHOLE Type, int AreaNo, PAREA pArea);

	void RewritableToMsgBox(PREWRITABLE pRewritable, ID_READWRITE Action);
	void SetRewritable(PREWRITABLE pRewritable);
	ID_RETURN GetRewritable(PREWRITABLE pRewritable);

	void ResolutionToMsgBox(BYTE Resolution, ID_READWRITE Action);
	void SetResolutionRadio(BYTE Resolution);
	ID_RETURN GetResolution(LPBYTE Resolution);

	BOOL PrinterIs600DPICapable();
	void EnableGetSetControls(BOOL bControl);

	BOOL ActionIsGet();
	void AddDriverMessage(CString pMessage);
};
